/*
 * File: hhb-get.cgi
 *
 *	Execute Home Heartbeat Command
 *
 *	Communicates with an HHB using a properly configured and installed FTDI
 *	driver. For instructions on installing driver see:
 *
 *		http://www.kolinahr.com/documentation/home-heartbeat/ ...
 *			usb-drivers-for-the-home-heartbeat/
 *
 *	The serial device is assumed to be at /dev/hhb. The DEV_PATH constant
 *	(below) will have to be modified, and the code recompiled, if using a
 *	differnt device.
 *
 *
 * Parameter:
 *
 *	The single 'command' parameter is passed using the http POST method.
 *
 *	command		- Command request to HHB.
 *			  Common HHB commands are:
 *
 *			s	- get next state record
 *			S	- get full state table
 *			p	- get ZigBee binding table
 *			\n	- get Base Station MAC address
 *
 *
 * Returns:
 *
 *	The results received from the Home Heartbeat are sent to stdout.
 *
 *
 * Author:
 *
 * 	Timothy Wagner, 2012
 *
 */

#include <stdlib.h>
#include <string.h>
#include "serial.h"

#define DEV_PATH "/dev/hhb"

extern	void	uriQuery2env(char *query, char *envPrefix);

int main()
	{
	unsigned long	i;
	long		urilen;
	int		fd_serial;
	char		*content_length;
	char		*uripost;
	char		*command;

	fputs("Content-Type: text/plain; charset=us-ascii\r\n\r\n", stdout);

	content_length = getenv("CONTENT_LENGTH");
	if (content_length != NULL &&
		sscanf(content_length, "%ld", &urilen) == 1)
		{
		uripost = malloc(urilen + 1);
		fgets(uripost, urilen + 1, stdin);
		uriQuery2env(uripost, "POST_");
		free(uripost);
		}

	command = getenv("POST_COMMAND");
	if (command == NULL || strlen(command) == 0)
		return 0;

	if ((fd_serial = serial_open(DEV_PATH)) != -1)
		{
		serial_setup(fd_serial, B38400, CS8, STOP_BITS_1, PARITY_NONE);
		serial_write(fd_serial, command, strlen(command));
		serial_write(fd_serial, "\n", 1);
		i = serial_read_to_file(fd_serial, stdout, 0);
		serial_close(fd_serial);
		printf("OUT=%ld,%ld\n\n", i, serial_elapsed_microsecs());
		}
	
	return 0;
	}
